/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public abstract class QueueItemAction
extends InvisibleAction
implements PersistentAction {
    private static final long serialVersionUID = 1L;

    @CheckForNull
    public abstract Queue.Item itemInQueue();

    @NonNull
    public static QueueState getNodeState(@NonNull FlowNode node) {
        WorkspaceAction workspaceAction = node.getPersistentAction(WorkspaceAction.class);
        if (workspaceAction != null) {
            return QueueState.LAUNCHED;
        }
        QueueItemAction action = node.getPersistentAction(QueueItemAction.class);
        if (action != null) {
            Queue.Item item = action.itemInQueue();
            if (item == null) {
                return QueueState.CANCELLED;
            }
            if (item instanceof Queue.LeftItem) {
                if (((Queue.LeftItem)item).isCancelled()) {
                    return QueueState.CANCELLED;
                }
                return QueueState.LAUNCHED;
            }
            return QueueState.QUEUED;
        }
        return QueueState.UNKNOWN;
    }

    @CheckForNull
    public static Queue.Item getQueueItem(@NonNull FlowNode node) {
        QueueItemAction action = node.getPersistentAction(QueueItemAction.class);
        return action != null ? action.itemInQueue() : null;
    }

    public static enum QueueState {
        QUEUED,
        CANCELLED,
        LAUNCHED,
        UNKNOWN;

    }
}

