/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graph;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.List;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public abstract class BlockEndNode<START extends BlockStartNode>
extends FlowNode {
    private transient START start;
    private final String startId;

    public BlockEndNode(FlowExecution exec, String id, START start, FlowNode ... parents) {
        super(exec, id, parents);
        this.start = start;
        this.startId = ((FlowNode)((Object)start)).getId();
    }

    public BlockEndNode(FlowExecution exec, String id, START start, List<FlowNode> parents) {
        super(exec, id, parents);
        this.start = start;
        this.startId = ((FlowNode)((Object)start)).getId();
    }

    @NonNull
    public START getStartNode() {
        if (this.start == null) {
            try {
                this.start = (BlockStartNode)this.getExecution().getNode(this.startId);
                if (this.start == null) {
                    throw new IllegalStateException("Matching start node " + this.startId + " lost from deserialization");
                }
            }
            catch (IOException x) {
                throw new IllegalStateException("Could not load matching start node: " + x);
            }
        }
        return this.start;
    }
}

