/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import com.google.common.io.Files;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Shell;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.durabletask.AgentInfo;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class BourneShellScript
extends FileMonitoringTask {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean USE_BINARY_WRAPPER = Boolean.getBoolean(BourneShellScript.class.getName() + ".USE_BINARY_WRAPPER");
    private static final Logger LOGGER = Logger.getLogger(BourneShellScript.class.getName());
    private static final String SYSTEM_DEFAULT_CHARSET = "SYSTEM_DEFAULT";
    private static final String LAUNCH_DIAGNOSTICS_PROP = BourneShellScript.class.getName() + ".LAUNCH_DIAGNOSTICS";
    private static boolean LAUNCH_DIAGNOSTICS = Boolean.getBoolean(LAUNCH_DIAGNOSTICS_PROP);
    static int HEARTBEAT_CHECK_INTERVAL = Integer.getInteger(BourneShellScript.class.getName() + ".HEARTBEAT_CHECK_INTERVAL", 300);
    private static int HEARTBEAT_MINIMUM_DELTA = Integer.getInteger(BourneShellScript.class.getName() + ".HEARTBEAT_MINIMUM_DELTA", 2);
    @NonNull
    private final String script;
    private boolean capturingOutput;

    @DataBoundConstructor
    public BourneShellScript(String script) {
        this.script = Util.fixNull((String)script);
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    @Override
    protected FileMonitoringTask.FileMonitoringController launchWithCookie(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        FilePath binary;
        if (this.script.isEmpty()) {
            listener.getLogger().println("Warning: was asked to run an empty script");
        }
        FilePath nodeRoot = BourneShellScript.getNodeRoot(ws);
        AgentInfo agentInfo = BourneShellScript.getAgentInfo(nodeRoot);
        AgentInfo.OsType os = agentInfo.getOs();
        String scriptEncodingCharset = "UTF-8";
        String jenkinsResultTxtEncoding = null;
        if (os == AgentInfo.OsType.ZOS) {
            Charset zOSSystemEncodingCharset = Charset.forName((String)ws.act((Callable)new getIBMzOsEncoding()));
            if (SYSTEM_DEFAULT_CHARSET.equals(this.getCharset())) {
                this.charset(zOSSystemEncodingCharset);
            }
            scriptEncodingCharset = zOSSystemEncodingCharset.name();
            jenkinsResultTxtEncoding = zOSSystemEncodingCharset.name();
        }
        ShellController c = new ShellController(ws, os == AgentInfo.OsType.ZOS, cookieValue, jenkinsResultTxtEncoding);
        FilePath shf = c.getScriptFile(ws);
        shf.write(this.script, scriptEncodingCharset);
        String shell = null;
        if (!this.script.startsWith("#!")) {
            shell = ((Shell.DescriptorImpl)Jenkins.get().getDescriptorByType(Shell.DescriptorImpl.class)).getShell();
            if (shell == null) {
                shell = "sh";
            }
        } else {
            shf.chmod(493);
        }
        String scriptPath = shf.getRemote();
        envVars.put(cookieVariable, "please-do-not-kill-me");
        List<String> launcherCmd = null;
        if (USE_BINARY_WRAPPER && (binary = BourneShellScript.requestBinary(nodeRoot, agentInfo, ws, c)) != null) {
            launcherCmd = this.binaryLauncherCmd(c, ws, shell, binary.getRemote(), scriptPath, cookieValue, cookieVariable);
        }
        if (launcherCmd == null) {
            launcherCmd = this.scriptLauncherCmd(c, ws, shell, os, scriptPath, cookieValue, cookieVariable);
        }
        LOGGER.log(Level.FINE, "launching {0}", launcherCmd);
        Launcher.ProcStarter ps = launcher.launch().cmds(launcherCmd).envs(BourneShellScript.escape(envVars)).pwd(ws).quiet(true);
        if (LAUNCH_DIAGNOSTICS) {
            ps.stdout(listener);
            ps.start();
        } else {
            ps.readStdout().readStderr();
            Proc p = ps.start();
            c.registerForCleanup(p.getStdout());
            c.registerForCleanup(p.getStderr());
        }
        return c;
    }

    @NonNull
    private List<String> binaryLauncherCmd(ShellController c, FilePath ws, @Nullable String shell, String binaryPath, String scriptPath, String cookieValue, String cookieVariable) throws IOException, InterruptedException {
        String logFile = c.getLogFile(ws).getRemote();
        String resultFile = c.getResultFile(ws).getRemote();
        String outputFile = c.getOutputFile(ws).getRemote();
        String controlDirPath = c.controlDir(ws).getRemote();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(binaryPath);
        cmd.add("-controldir=" + controlDirPath);
        cmd.add("-result=" + resultFile);
        cmd.add("-log=" + logFile);
        cmd.add("-cookiename=" + cookieVariable);
        cmd.add("-cookieval=" + cookieValue);
        cmd.add("-script=" + scriptPath);
        if (shell != null) {
            cmd.add("-shell=" + shell);
        }
        if (this.capturingOutput) {
            cmd.add("-output=" + outputFile);
        }
        cmd.add("-daemon");
        if (LAUNCH_DIAGNOSTICS) {
            cmd.add("-debug");
        }
        return cmd;
    }

    @NonNull
    private List<String> scriptLauncherCmd(ShellController c, FilePath ws, @CheckForNull String shell, AgentInfo.OsType os, String scriptPath, String cookieValue, String cookieVariable) throws IOException, InterruptedException {
        FilePath logFile = c.getLogFile(ws);
        FilePath resultFile = c.getResultFile(ws);
        FilePath controlDir = c.controlDir(ws);
        Object interpreter = "";
        if (shell != null && !this.script.startsWith("#!")) {
            interpreter = "'" + shell + "' -xe ";
        }
        if (os == AgentInfo.OsType.WINDOWS) {
            scriptPath = scriptPath.replace("\\", "/");
        }
        String scriptPathCopy = scriptPath + ".copy";
        String cmdString = this.capturingOutput ? String.format("cp '%s' '%s'; { while [ -d '%s' -a \\! -f '%s' ]; do touch '%s'; sleep 3; done } & jsc=%s; %s=$jsc %s '%s' > '%s' 2> '%s'; echo $? > '%s.tmp'; mv '%s.tmp' '%s'; wait", scriptPath, scriptPathCopy, controlDir, resultFile, logFile, cookieValue, cookieVariable, interpreter, scriptPathCopy, c.getOutputFile(ws), logFile, resultFile, resultFile, resultFile) : String.format("cp '%s' '%s'; { while [ -d '%s' -a \\! -f '%s' ]; do touch '%s'; sleep 3; done } & jsc=%s; %s=$jsc %s '%s' > '%s' 2>&1; echo $? > '%s.tmp'; mv '%s.tmp' '%s'; wait", scriptPath, scriptPathCopy, controlDir, resultFile, logFile, cookieValue, cookieVariable, interpreter, scriptPathCopy, logFile, resultFile, resultFile, resultFile);
        cmdString = cmdString.replace("$", "$$");
        ArrayList<String> cmd = new ArrayList<String>();
        if (os != AgentInfo.OsType.DARWIN) {
            cmd.add("nohup");
        }
        if (LAUNCH_DIAGNOSTICS) {
            cmd.addAll(Arrays.asList("sh", "-c", cmdString));
        } else {
            cmd.addAll(Arrays.asList("sh", "-c", "(" + cmdString + ") >&- 2>&- &"));
        }
        return cmd;
    }

    private static final class getIBMzOsEncoding
    extends MasterToSlaveCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private getIBMzOsEncoding() {
        }

        public String call() throws RuntimeException {
            return System.getProperty("ibm.system.encoding");
        }
    }

    static final class ShellController
    extends FileMonitoringTask.FileMonitoringController {
        private transient long lastCheck;
        private transient long checkedTimestamp;
        private final boolean isZos;
        private String jenkinsResultTxtEncoding;
        private static final long serialVersionUID = 1L;

        private ShellController(FilePath ws, boolean zOsFlag, @NonNull String cookieValue, String jenkinsResultTxtEncoding) throws IOException, InterruptedException {
            super(ws, cookieValue);
            this.isZos = zOsFlag;
            this.jenkinsResultTxtEncoding = jenkinsResultTxtEncoding;
        }

        public FilePath getScriptFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("script.sh");
        }

        private FilePath pidFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("pid");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected Integer exitStatus(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
            long currentTimestamp;
            block10: {
                block9: {
                    Integer status;
                    if (this.isZos) {
                        FilePath statusFile = this.getResultFile(workspace);
                        status = (Integer)statusFile.act((FilePath.FileCallable)new StatusCheckWithEncoding(this.jenkinsResultTxtEncoding != null ? this.jenkinsResultTxtEncoding : this.getCharset()));
                    } else {
                        status = super.exitStatus(workspace, listener);
                    }
                    if (status != null) {
                        LOGGER.log(Level.FINE, "found exit code {0} in {1}", new Object[]{status, this.controlDir});
                        return status;
                    }
                    long now = System.nanoTime();
                    if (this.lastCheck == 0L) {
                        LOGGER.log(Level.FINE, "starting check in {0}", this.controlDir);
                        this.lastCheck = now;
                        return null;
                    }
                    if (now <= this.lastCheck + TimeUnit.SECONDS.toNanos(HEARTBEAT_CHECK_INTERVAL)) return null;
                    this.lastCheck = now;
                    currentTimestamp = this.getLogFile(workspace).lastModified();
                    if (currentTimestamp == 0L) {
                        listener.getLogger().println("process apparently never started in " + this.controlDir);
                        if (LAUNCH_DIAGNOSTICS) return this.recordExitStatus(workspace, -2);
                        listener.getLogger().println("(running Jenkins temporarily with -D" + LAUNCH_DIAGNOSTICS_PROP + "=true might make the problem clearer)");
                        return this.recordExitStatus(workspace, -2);
                    }
                    if (this.checkedTimestamp <= 0L) break block9;
                    if (currentTimestamp < this.checkedTimestamp) {
                        listener.getLogger().println("apparent clock skew in " + this.controlDir);
                        break block10;
                    } else if (currentTimestamp < this.checkedTimestamp + TimeUnit.SECONDS.toMillis(HEARTBEAT_MINIMUM_DELTA)) {
                        FilePath pidFile = this.pidFile(workspace);
                        if (!pidFile.exists()) {
                            listener.getLogger().println("wrapper script does not seem to be touching the log file in " + this.controlDir);
                            listener.getLogger().println("(JENKINS-48300: if on an extremely laggy filesystem, consider -Dorg.jenkinsci.plugins.durabletask.BourneShellScript.HEARTBEAT_CHECK_INTERVAL=86400)");
                            return this.recordExitStatus(workspace, -1);
                        }
                        listener.getLogger().println("still have " + pidFile + " so heartbeat checks unreliable; process may or may not be alive");
                    }
                    break block10;
                }
                LOGGER.log(Level.FINE, "seeing recent log file modifications in {0}", this.controlDir);
            }
            this.checkedTimestamp = currentTimestamp;
            return null;
        }

        private int recordExitStatus(FilePath workspace, int code) throws IOException, InterruptedException {
            this.getResultFile(workspace).write(Integer.toString(code), null);
            return code;
        }
    }

    static class StatusCheckWithEncoding
    extends MasterToSlaveFileCallable<Integer> {
        private final String charset;

        StatusCheckWithEncoding(String charset) {
            this.charset = charset;
        }

        @CheckForNull
        public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            if (f.exists() && f.length() > 0L) {
                try {
                    String fileString = Files.readFirstLine((File)f, (Charset)Charset.forName(this.charset));
                    if (fileString == null || fileString.isEmpty()) {
                        return null;
                    }
                    if ((fileString = fileString.trim()).isEmpty()) {
                        return null;
                    }
                    return Integer.parseInt(fileString);
                }
                catch (NumberFormatException x) {
                    throw new IOException("corrupted content in " + f + " using " + this.charset + ": " + x, x);
                }
            }
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.BourneShellScript_bourne_shell();
        }
    }
}

