/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorFactory;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.trilead.ssh2.Connection;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.jenkinsci.plugins.variant.OptionalExtension;

public class TrileadSSHPasswordAuthenticator
extends SSHAuthenticator<Connection, StandardUsernamePasswordCredentials> {
    private static final Logger LOGGER = Logger.getLogger(TrileadSSHPasswordAuthenticator.class.getName());
    private static final String PASSWORD = "password";
    private static final String KEYBOARD_INTERACTIVE = "keyboard-interactive";

    @Deprecated
    public TrileadSSHPasswordAuthenticator(Connection connection, StandardUsernamePasswordCredentials user) {
        this(connection, user, (String)null);
    }

    public TrileadSSHPasswordAuthenticator(@NonNull Connection connection, @NonNull StandardUsernamePasswordCredentials user, @CheckForNull String username) {
        super(connection, user, username);
    }

    @Override
    public boolean canAuthenticate() {
        try {
            for (String authMethod : ((Connection)this.getConnection()).getRemainingAuthMethods(this.getUsername())) {
                if (PASSWORD.equals(authMethod)) {
                    return true;
                }
                if (!KEYBOARD_INTERACTIVE.equals(authMethod)) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.getListener().error("Failed to authenticate"));
        }
        return false;
    }

    @Override
    protected boolean doAuthenticate() {
        StandardUsernamePasswordCredentials user = (StandardUsernamePasswordCredentials)this.getUser();
        String username = this.getUsername();
        try {
            Connection connection = (Connection)this.getConnection();
            String password = user.getPassword().getPlainText();
            boolean tried = false;
            List<String> availableMethods = Arrays.asList(connection.getRemainingAuthMethods(username));
            if (availableMethods.contains(PASSWORD)) {
                if (connection.authenticateWithPassword(username, password)) {
                    LOGGER.fine("Authentication with 'password' succeeded.");
                    return true;
                }
                this.getListener().error("Failed to authenticate as %s. Wrong password. (credentialId:%s/method:password)", new Object[]{username, user.getId()});
                tried = true;
            }
            if (availableMethods.contains(KEYBOARD_INTERACTIVE)) {
                if (connection.authenticateWithKeyboardInteractive(username, (name, instruction, numPrompts, prompt, echo) -> {
                    String[] stringArray;
                    if (prompt != null && prompt.length > 0 && prompt[0].toLowerCase(Locale.ENGLISH).contains("assword")) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = password;
                    } else {
                        stringArray = new String[]{};
                    }
                    return stringArray;
                })) {
                    LOGGER.fine("Authentication with  'keyboard-interactive' succeeded.");
                    return true;
                }
                this.getListener().error("Failed to authenticate as %s. Wrong password. (credentialId:%s/method:keyboard-interactive)", new Object[]{username, user.getId()});
                tried = true;
            }
            if (!tried) {
                this.getListener().error("The server does not allow password authentication. Available options are %s", new Object[]{availableMethods});
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.getListener().error("Unexpected error while trying to authenticate as %s with credential=%s", new Object[]{username, user.getId()}));
        }
        return false;
    }

    @OptionalExtension(requirePlugins={"trilead-api"})
    public static class Factory
    extends SSHAuthenticatorFactory {
        private static final long serialVersionUID = 1L;

        @Override
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user) {
            return this.newInstance(connection, user, null);
        }

        @Override
        @Nullable
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user, @CheckForNull String username) {
            if (this.supports(connection.getClass(), user.getClass())) {
                return new TrileadSSHPasswordAuthenticator((Connection)connection, (StandardUsernamePasswordCredentials)user, username);
            }
            return null;
        }

        @Override
        protected <C, U extends StandardUsernameCredentials> boolean supports(@NonNull Class<C> connectionClass, @NonNull Class<U> userClass) {
            return Connection.class.isAssignableFrom(connectionClass) && StandardUsernamePasswordCredentials.class.isAssignableFrom(userClass);
        }
    }
}

