/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousResumeNotSupportedException;

public abstract class GeneralNonBlockingStepExecution
extends StepExecution {
    private static final long serialVersionUID = 1L;
    private volatile transient Future<?> task;
    private String threadName;
    private volatile transient Throwable stopCause;

    protected GeneralNonBlockingStepExecution(StepContext context) {
        super(context);
    }

    protected final void run(Block block) {
        if (this.stopCause != null) {
            return;
        }
        Authentication auth = Jenkins.getAuthentication();
        this.task = SynchronousNonBlockingStepExecution.getExecutorService().submit(() -> {
            this.threadName = Thread.currentThread().getName();
            try (ACLContext acl = ACL.as((Authentication)auth);){
                block.run();
            }
            catch (Throwable x) {
                if (this.stopCause == null) {
                    this.getContext().onFailure(x);
                } else {
                    this.stopCause.addSuppressed(x);
                }
            }
            finally {
                this.threadName = null;
                this.task = null;
            }
        });
    }

    @Override
    public void stop(Throwable cause) throws Exception {
        this.stopCause = cause;
        if (this.task != null) {
            this.task.cancel(true);
        }
        super.stop(cause);
    }

    @Override
    public void onResume() {
        if (this.threadName != null) {
            this.getContext().onFailure(new SynchronousResumeNotSupportedException());
        }
    }

    @Override
    @NonNull
    public String getStatus() {
        if (this.threadName != null) {
            return "running in thread: " + this.threadName;
        }
        return "not currently scheduled, or running blocks";
    }

    @Override
    public boolean blocksRestart() {
        return this.threadName != null;
    }

    @FunctionalInterface
    protected static interface Block {
        public void run() throws Exception;
    }

    protected abstract class TailCall
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 1L;

        protected TailCall() {
        }

        protected abstract void finished(StepContext var1) throws Exception;

        @Override
        public final void onSuccess(StepContext context, Object result) {
            GeneralNonBlockingStepExecution.this.run(() -> {
                try {
                    this.finished(context);
                }
                catch (Exception x) {
                    if (GeneralNonBlockingStepExecution.this.stopCause == null) {
                        context.onFailure(x);
                    } else {
                        GeneralNonBlockingStepExecution.this.stopCause.addSuppressed(x);
                    }
                    return;
                }
                context.onSuccess(result);
            });
        }

        @Override
        public final void onFailure(StepContext context, Throwable t) {
            GeneralNonBlockingStepExecution.this.run(() -> {
                try {
                    this.finished(context);
                }
                catch (Exception x) {
                    t.addSuppressed(x);
                }
                context.onFailure(t);
            });
        }
    }
}

