/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class MissingContextVariableException
extends Exception {
    @NonNull
    private final Class<?> type;
    @CheckForNull
    private final String functionName;
    private static final long serialVersionUID = 1L;

    @Deprecated
    public MissingContextVariableException(@NonNull Class<?> type) {
        this(type, null);
    }

    public MissingContextVariableException(@NonNull Class<?> type, @CheckForNull StepDescriptor d) {
        this.type = type;
        this.functionName = d != null ? d.getFunctionName() : null;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder("Required context ").append(this.type).append(" is missing");
        boolean first = true;
        for (StepDescriptor p : this.getProviders()) {
            if (first) {
                b.append("\nPerhaps you forgot to surround the ");
                if (this.functionName != null) {
                    b.append(this.functionName).append(" ");
                }
                b.append("step with a step that provides this, such as: ");
                first = false;
            } else {
                b.append(", ");
            }
            b.append(p.getFunctionName());
        }
        return b.toString();
    }

    @NonNull
    public List<StepDescriptor> getProviders() {
        ArrayList<StepDescriptor> r = new ArrayList<StepDescriptor>();
        for (StepDescriptor sd : StepDescriptor.all()) {
            if (!this.isIn(sd.getProvidedContext()) || this.isIn(sd.getRequiredContext())) continue;
            r.add(sd);
        }
        return r;
    }

    private boolean isIn(Set<? extends Class<?>> classes) {
        for (Class<?> t : classes) {
            if (!this.type.isAssignableFrom(t)) continue;
            return true;
        }
        return false;
    }
}

