/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUser;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;

public class BaseSSHUser
extends BaseStandardCredentials
implements SSHUser,
StandardUsernameCredentials {
    private static final long serialVersionUID = 1L;
    protected final String username;
    @Nullable
    private Boolean usernameSecret = false;

    public BaseSSHUser(CredentialsScope scope, String id, String username, String description) {
        super(scope, id, description);
        this.username = username;
    }

    protected Object readResolve() {
        if (this.usernameSecret == null) {
            this.usernameSecret = true;
        }
        return this;
    }

    @NonNull
    public String getUsername() {
        return StringUtils.isEmpty((String)this.username) ? System.getProperty("user.name") : this.username;
    }

    public boolean isUsernameSecret() {
        return this.usernameSecret;
    }

    @DataBoundSetter
    public void setUsernameSecret(boolean usernameSecret) {
        this.usernameSecret = usernameSecret;
    }
}

